/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.FlexDescEditorShell.CloseInternalFrameListener;
import net.nooj4nlp.controller.FlexDescEditorShell.FlexDescEditorShellController;
import net.nooj4nlp.controller.FlexDescEditorShell.SyntaxColorActionListener;
import net.nooj4nlp.controller.FlexDescEditorShell.TextDocumentListener;
import net.nooj4nlp.gui.actions.documents.CopyActionListener;
import net.nooj4nlp.gui.actions.documents.CutActionListener;
import net.nooj4nlp.gui.actions.documents.PasteActionListener;
import net.nooj4nlp.gui.actions.documents.SelectAllActionListener;
import net.nooj4nlp.gui.actions.shells.modify.ContextMenuMouseListener;
import net.nooj4nlp.gui.main.Launcher;

public class FlexDescEditorShell
extends JInternalFrame {
    private static final long serialVersionUID = -8122529763446499249L;
    private JTextPane textPane;
    private JPopupMenu popText;
    private JMenuItem menuItem;
    private FlexDescEditorShellController controller;

    public FlexDescEditorShell() {
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setBounds(100, 100, 750, 500);
        this.setDefaultCloseOperation(0);
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("ins 7", "[grow,fill,left][50::,right]", "10![]10![grow, fill]"));
        JLabel lblLineNo = new JLabel("Ln n");
        panel.add((Component)lblLineNo, "skip");
        JLabel lblColNo = new JLabel("Col n");
        panel.add((Component)lblColNo, "gapleft 30, wrap");
        this.textPane = new JTextPane();
        this.textPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        noWrapPanel.add(this.textPane);
        JScrollPane scrollPane = new JScrollPane(noWrapPanel);
        panel.add((Component)scrollPane, "span");
        this.getContentPane().add(panel);
        this.popText = new JPopupMenu();
        this.menuItem = new JMenuItem("Syntax Color");
        this.popText.add(this.menuItem);
        Style style = this.textPane.addStyle("black", null);
        StyleConstants.setForeground(style, Color.black);
        Style style1 = this.textPane.addStyle("red", null);
        StyleConstants.setForeground(style1, Color.red);
        Style style2 = this.textPane.addStyle("green", null);
        StyleConstants.setForeground(style2, new Color(20, 180, 62));
        Style style3 = this.textPane.addStyle("blue", null);
        StyleConstants.setForeground(style3, Color.blue);
        Style style4 = this.textPane.addStyle("orange", null);
        StyleConstants.setForeground(style4, Color.orange);
        Style style5 = this.textPane.addStyle("gray", null);
        StyleConstants.setForeground(style5, Color.darkGray);
        this.getContentPane().addMouseListener(new ContextMenuMouseListener(this.popText));
        this.textPane.addMouseListener(new ContextMenuMouseListener(this.popText));
        this.controller = new FlexDescEditorShellController(this.textPane, this);
        this.textPane.getDocument().addDocumentListener(new TextDocumentListener(this.controller));
        this.addInternalFrameListener(new CloseInternalFrameListener(this.controller));
        this.menuItem.addActionListener(new SyntaxColorActionListener(this.controller));
        Launcher.mnEdit.setVisible(true);
        JMenuItem mntmCut = Launcher.getTextCommands().get("Cut");
        JMenuItem mntmCopy = Launcher.getTextCommands().get("Copy");
        JMenuItem mntmPaste = Launcher.getTextCommands().get("Paste");
        JMenuItem mntmSelectAll = Launcher.getTextCommands().get("Select All");
        mntmCut.addActionListener(new CutActionListener(this.textPane));
        mntmCopy.addActionListener(new CopyActionListener(this.textPane));
        mntmPaste.addActionListener(new PasteActionListener(this.textPane));
        mntmSelectAll.addActionListener(new SelectAllActionListener(this.textPane));
    }

    public void modifyFont(String fontFamily, int fontSize) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, fontFamily);
        StyleConstants.setFontSize(attr, fontSize);
        StyleConstants.setForeground(attr, Color.darkGray);
        int textLength = this.textPane.getText().length();
        this.textPane.getStyledDocument().setParagraphAttributes(0, textLength, attr, false);
        this.textPane.repaint();
    }

    public FlexDescEditorShellController getController() {
        return this.controller;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }
}

